IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_CORRIGE_DT_ENT_EMI_NF_IT')
BEGIN 
    DROP PROCEDURE P_CORRIGE_DT_ENT_EMI_NF_IT;
END 
GO

CREATE PROCEDURE P_CORRIGE_DT_ENT_EMI_NF_IT (@REFINI DATE,  @REFFIM DATE)

AS

SET NOCOUNT ON;
	DECLARE @CD_CHAVE_FILIAL INT ;
	 
	DECLARE C_CHAVE CURSOR FAST_FORWARD FOR
	SELECT CD_FILIAL  
		FROM PRC_FILIAL 
		ORDER BY CD_FILIAL

	OPEN C_CHAVE
	FETCH NEXT FROM C_CHAVE INTO @CD_CHAVE_FILIAL
	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'PROCESANDO LJ ' + CONVERT(VARCHAR, @CD_CHAVE_FILIAL)
			PRINT 'NF ENTRADA ' 
				UPDATE I
				SET
					DT_ENT=N.DT_ENT
				FROM
					EST_NF_ENT N
					JOIN EST_NF_ENT_IT I ON 
					N.CD_EMP	=I.CD_EMP AND
					N.CD_FILIAL =I.CD_FILIAL AND
					N.CD_NF		=I.CD_NF
				WHERE
					I.DT_ENT<> N.DT_ENT
					AND N.CD_EMP=1
					AND N.CD_FILIAL= @CD_CHAVE_FILIAL
					AND N.DT_ENT BETWEEN @REFINI AND @REFFIM;  

				PRINT 'NF SAIDA ' 
				UPDATE I
				SET
					DT_EMI_NF =N.DT_EMI_NF
				FROM
					EST_NF_SAI N
					JOIN EST_NF_SAI_IT I ON 
					N.CD_EMP	=I.CD_EMP AND
					N.CD_FILIAL =I.CD_FILIAL AND
					N.CD_NF		=I.CD_NF
				WHERE
					I.DT_EMI_NF<> N.DT_EMI_NF
					AND N.CD_EMP=1
					AND N.CD_FILIAL= @CD_CHAVE_FILIAL
					AND N.DT_EMI_NF BETWEEN @REFINI AND @REFFIM;  


			FETCH NEXT FROM C_CHAVE INTO @CD_CHAVE_FILIAL
		END
	CLOSE C_CHAVE;
	DEALLOCATE C_CHAVE; 
